; HW_console.asm - Hello, world via a console program
;
; A console application is essentially a Win32 app without any of
; the GUI bits, and runs in a DOS-box. You still have access to
; the Win32 API though and this is what makes them powerful.
; A console app is an excellent choice when you want to take
; advantage of Win32 but not worry about the GUI.
;

%define _WINCONSOLE_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]
;
; main is where the program starts, and works just like WinMain
; (see Examples\01 Hello World\HW_msgbox.asm) Don't forget to
; change the linker option to specify main and not WinMain.
;
procglobal main
	ddlocal		hStdIn, hStdOut, ddStrLen
	endlocals
	;
	; Consoles have quite a few functions, here's one that
	; sets the title of the console window
	;
	TEXTlocal szTitle, 'Console',0
	sc SetConsoleTitle, .szTitle
	;
	; Before we can read or write to the console we need
	; to obtain handles to the input/output devices. Note
	; the use of the . prefix as we're using local variables.
	; Also note that there are no [] around the local variables
	; as it's not necessary
	;
	sc GetStdHandle, STD_INPUT_HANDLE
	mov	.hStdIn, eax
	sc GetStdHandle, STD_OUTPUT_HANDLE
	mov	.hStdOut, eax
	;
	; We use the output handle to write a string to the console.
	; The WriteConsole function needs to know the length of the
	; string to write so I use the double-dot prefix to get the
	; end of the string and work out it's length. Note I don't
	; append a null-terminator as the function takes the number
	; of characters to write.
	;
	TEXTlocal szString, 'Hello, world!'
	mov	eax, ..szString
	sub	eax, .szString
	;
	; I use .Temp as a location to hold the number of
	; characters written, it's not important here.
	;
	TEXTlocal Temp, 0
	sc WriteConsole, .hStdOut, .szString, eax, .Temp, NULL
	;
	; Now wait for return via ReadConsole
	;
	sc ReadConsole, .hStdIn, .szString, 1, .Temp, NULL
	;
	; and exit the application
	;
	sc ExitProcess, 0
endproc

[section .data]
